// normally the model is passed to the view instead of the view creating the model
define([
    'backbone',
    'marionette',
    'modules/form/section-view',
    'text!modules/form/section-with-heading.html',
    'json!modules/new-appointment-request/views/requests/message/section.json',
],
function(
    Backbone,
    Marionette,
    SectionView,
    template,
    metadata
) {
    'use strict';

    return SectionView.extend({
        className: 'form-section form-section-with-description',
        template: template,
        initialize: function(options) {
            var sectionName = 'new-message-section';
            this.legend = this.getLegendFromMetadata(sectionName, metadata, false) || '';
            this.collection = this.getQuestionsFromMetadata(sectionName, metadata);

            // initialize listener to 'change:value' after static values are set
            this.initializeQuestionEventListeners();
        },
    });
});
